﻿#include  "StdAfx.h"

#include  "szPropertyConversions.hpp"
#include  <szRuntimeException.hpp>
#include  <szFiletime.hpp>
#include  <7zip/Archive/IArchive.h>

using namespace NWindows::NCOM;

SZ_AN_BEG

inline void ThrowIfNotOK_GetProperty(HRESULT result)
{
  if (S_OK != result)
    BOOST_THROW_EXCEPTION(szpp::RuntimeException(SZT("Cannot get property")));
}

SZ_AN_END

SZ_NS_BEG(szpp)

szstring ConvertPropVariantToString(const NWindows::NCOM::CPropVariant &propVariant)
{
  if (VT_BSTR == propVariant.vt)
    return szstring(propVariant.bstrVal);
  return SZL_EMPTY;
}

u64 ConvertPropVariantToU64(const CPropVariant &propVariant)
{
  switch (propVariant.vt)
  {
  case VT_UI1:
    return propVariant.bVal;
  case VT_UI2:
    return propVariant.uiVal;
  case VT_UI4:
    return propVariant.ulVal;
  case VT_UI8:
    return propVariant.uhVal.QuadPart;
  }
  return 0;
}

u32 ConvertPropVariantToU32(const NWindows::NCOM::CPropVariant &propVariant)
{
  switch (propVariant.vt)
  {
  case VT_I1:
    return propVariant.cVal;
  case VT_UI1:
    return propVariant.bVal;
  case VT_I2:
    return propVariant.iVal;
  case VT_UI2:
    return propVariant.uiVal;
  case VT_I4:
    return propVariant.lVal;
  case VT_UI4:
    return propVariant.ulVal;
  }

  return 0;
}

bool ConvertPropVariantToBool(const NWindows::NCOM::CPropVariant & propVariant)
{
  if (VT_BOOL == propVariant.vt)
    return (0 != propVariant.boolVal);

  return false;
}

Time ConvertPropVariantToTime(const NWindows::NCOM::CPropVariant &propVariant)
{
  if (VT_FILETIME == propVariant.vt)
    return FiletimeToTime(propVariant.filetime);

  // TODO: ほかの日時形式からの変換もサポート？？？ 7-Zip が既に変換してくれているなら不要だが。

  return Time(0);
}

szstring GetStringProperty(IInArchive *archive, index_t index, PROPID propID)
{
  CPropVariant variant;
  ThrowIfNotOK_GetProperty(archive->GetProperty(static_cast<UInt32>(index), propID, &variant));
  return ConvertPropVariantToString(variant);
}

u64 GetU64Property(IInArchive *archive, index_t index, PROPID propID)
{
  CPropVariant variant;
  ThrowIfNotOK_GetProperty(archive->GetProperty(static_cast<UInt32>(index), propID, &variant));
  return ConvertPropVariantToU64(variant);
}

u32 GetU32Property(IInArchive *archive, index_t index, PROPID propID)
{
  CPropVariant variant;
  ThrowIfNotOK_GetProperty(archive->GetProperty(static_cast<UInt32>(index), propID, &variant));
  return ConvertPropVariantToU32(variant);
}

bool GetBoolProperty(IInArchive *archive, index_t index, PROPID propID)
{
  CPropVariant variant;
  ThrowIfNotOK_GetProperty(archive->GetProperty(static_cast<UInt32>(index), propID, &variant));
  return ConvertPropVariantToBool(variant);
}

Time GetTimeProperty(IInArchive *archive, index_t index, PROPID propID)
{
  CPropVariant variant;
  ThrowIfNotOK_GetProperty(archive->GetProperty(static_cast<UInt32>(index), propID, &variant));
  return ConvertPropVariantToTime(variant);
}

SZ_NS_END(szpp)
